LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
PACKAGE memory IS
  CONSTANT width   : INTEGER := 3;
  CONSTANT memsize : INTEGER := 7;

  TYPE data_out IS ARRAY(0 TO width) OF std_logic;
  TYPE mem_data IS ARRAY(0 TO memsize) OF data_out;
END memory;

LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
USE WORK.memory.ALL;
ENTITY rom IS
  PORT( addr : IN INTEGER;
        data : OUT data_out;
        cs   : IN std_logic);
END rom;

ARCHITECTURE basic OF rom IS
  CONSTANT z_state : data_out := ('Z', 'Z', 'Z', 'Z');
  CONSTANT x_state : data_out := ('X', 'X', 'X', 'X');
  CONSTANT rom_data : mem_data :=
    ( ( '0', '0', '0', '0'),
    ( '0', '0', '0', '1'),
    ( '0', '0', '1', '0'),
    ( '0', '0', '1', '1'),
    ( '0', '1', '0', '0'),
    ( '0', '1', '0', '1'),
    ( '0', '1', '1', '0'),
    ( '0', '1', '1', '1') );
BEGIN
  ASSERT addr <= memsize
    REPORT "addr out of range"
    SEVERITY ERROR;

  data <= rom_data(addr) AFTER 10 ns WHEN cs = '1' ELSE
          z_state AFTER 20 ns WHEN cs = '0' ELSE
          x_state AFTER 10 ns;
END basic;


